// DrvTest.cpp : Example application using the BQ Driver
//

#include "stdafx.h"
#include "bq_drv.h"

int _tmain(int argc, TCHAR *argv[], TCHAR *envp[])
{
	

	HANDLE hBQ;
	BYTE szBuf[1024];
	DWORD written = 0;

	_tprintf_s(_T("Welcome\n"));
	
	//Load the BQ driver

	_tprintf_s(_T("Trying CreateFile... "));

	hBQ = CreateFile(_T("BQD1:"),GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
	if(hBQ == INVALID_HANDLE_VALUE) {
		_tprintf_s(_T("Could not open BQD1\n"));
		return 0; //TODO: return something else on failure
	}
	_tprintf_s(_T("Done!\n\n"));

	/***********************************************************
	IOCTL Test: write and subsequently read the ATRate register.
	************************************************************/

	_tprintf_s(_T("Trying IOControl...\n"));

	//write ATRate

	memset(szBuf,0,sizeof(BYTE)*1024);
	szBuf[0] = 0x02;
	szBuf[1] = 0x9C;
	szBuf[2] = 0xFF;
	_tprintf_s(_T("Writing %hx, %hx to address %hx\n"),szBuf[1],szBuf[2],szBuf[0]);

	//ERROR Checking not implemented: Please implement your own
	DeviceIoControl(hBQ,IOCTL_I2CWRITE,szBuf,3,NULL,NULL,&written,NULL);

	_tprintf_s(_T("Wrote %d bytes\n"),written);

	//read ATRate

	memset(szBuf,0,sizeof(BYTE)*1024);
	BYTE cmd = 0x02;

	_tprintf_s(_T("reading 2 bytes from address %hx\n"),cmd);

	//ERROR Checking not implemented: Please implement your own
	DeviceIoControl(hBQ,IOCTL_I2CREAD,&cmd,1,szBuf,2,&written,NULL);

	_tprintf_s(_T("read: byte 0: %hx     byte 1: %hx\n"),szBuf[0],szBuf[1]);

	_tprintf_s(_T("Done!\n\n"));

	/**************************************************************
	READ/WRITE ACCESS: Utilize Basic Structures to read w/out IOCTL
	***************************************************************/

	_tprintf_s(_T("Trying ReadFile... \n"));

	BQ_Data myData;

	ReadFile(hBQ,&myData,sizeof(BQ_Data),&written,NULL);

	_tprintf(_T("myData.AtRate: %x\n"),myData.AtRate);
	_tprintf(_T("myData.AtRateTTE: %x\n"),myData.AtRateTTE);
	_tprintf(_T("myData.AvailEnergy: %x\n"),myData.AvailEnergy);
	_tprintf(_T("myData.AvgCurr: %x\n"),myData.AvgCurr);
	_tprintf(_T("myData.AvgPow: %x\n"),myData.AvgPow);
	_tprintf(_T("myData.Control: %x\n"),myData.Control);
	_tprintf(_T("myData.CycleCnt: %x\n"),myData.CycleCnt);
	_tprintf(_T("myData.Flags: %x\n"),myData.Flags);
	_tprintf(_T("myData.FullAvailCap: %x\n"),myData.FullAvailCap);
	_tprintf(_T("myData.FullChgCap: %x\n"),myData.FullChgCap);
	_tprintf(_T("myData.MaxLoadCurr: %x\n"),myData.MaxLoadCurr);
	_tprintf(_T("myData.MaxLoadTTE: %x\n"),myData.MaxLoadTTE);
	_tprintf(_T("myData.NomAvailCap: %x\n"),myData.NomAvailCap);
	_tprintf(_T("myData.RemCap: %x\n"),myData.RemCap);
	_tprintf(_T("myData.StateOfChg: %x\n"),myData.StateOfChg);
	_tprintf(_T("myData.StbyCurr: %x\n"),myData.StbyCurr);
	_tprintf(_T("myData.StbyTTE: %x\n"),myData.StbyTTE);
	_tprintf(_T("myData.Temp: %x\n"),myData.Temp);
	_tprintf(_T("myData.TTE: %x\n"),myData.TTE);
	_tprintf(_T("myData.TTEAtConstPow: %x\n"),myData.TTEAtConstPow);
	_tprintf(_T("myData.TTF: %x\n"),myData.TTF);
	_tprintf(_T("myData.Voltage: %x\n"),myData.Voltage);

	_tprintf_s(_T("\nDone!\n\n"));
	CloseHandle(hBQ);

    return 0;
}


/*
	char dummy[11];
	HINSTANCE hInstDLL;
	FARPROC fnPtr;
	int test = 0;
	*/

/*
	hInstDLL = LoadLibrary(TEXT("BQDrv.dll"));
	if(hInstDLL == NULL) {
		_tprintf(_T("Failed To Load BQDriver!\n"));
		gets_s(dummy,10);
		return 0;
	}

	fnPtr = GetProcAddress(hInstDLL,TEXT("GetBQStatus"));

	if(fnPtr == NULL) {
		_tprintf(_T("Failed to find process name\n"));
		gets_s(dummy,10);
		return 0;
	}
	test = fnPtr();

	_tprintf(_T("test is: %d\n"),test);
	

	FreeLibrary(hInstDLL);
	*/